/*****************************************************************************
*  LPC15xx blinky program for LPCXpresso board
*
*  1. Use SCT2 timer to generate a 10 msec timer tick (interrupt driven).
*  2. Toggle P0_25 (red LED) every 200 msec
*****************************************************************************/
#include "LPC15xx.h"

extern void SCT2_Init(void);

void SCT2_IRQHandler(void)
{                                                  // SCT2 Interrupt Handler (10 msec)
  static uint8_t cnt = 0;

    if (++cnt > 20)                                // 20 * 10 msec = 200 msec
    {
        cnt = 0;
        LPC_GPIO->NOT[0] = (1 << 7);              // toggle pin P0_7
    }
    LPC_SCT2->EVFLAG = 0x00000001;                 // clear event 0 flag
}

int main (void)
{
    LPC_SYSCON->SYSAHBCLKCTRL0 |= EN0_GPIO0;       // enable clock to GPIO port 0
    LPC_GPIO->DIR[0]           |= (1 << 7);       // configure P0_25 (red LED) as output

    SCT2_Init();                                   // Initialize SCT

    while (1)                                      // loop forever
    {
    }
}
